#include "MDSFxx_SFR.h"
#include "XSFR_GLOBAL.h"
#include "Allhex.h"

bit led_flashing_sw=0;
xdata uint8	 led_flashing_times=0;
xdata uint16 led_flashing_count=0;

//********************************************************************************
//								   LED_Init
//********************************************************************************
#if (dLED_MODE == 1)
	void LED_Flashing(void){
		if(led_flashing_sw==0){
			led_flashing_sw = 1;
			if(MotorErrorState<=16){
				led_flashing_times = dLED_Flashing_OCP*2;
				if(MotorErrorState<=8){
					led_flashing_times = dLED_Flashing_LOCK*2;
					if(MotorErrorState<=4){
						led_flashing_times = dLED_Flashing_OTP*2;
						if(MotorErrorState<=2){
							led_flashing_times = dLED_Flashing_UVP*2;
							if(MotorErrorState==1)
								led_flashing_times = dLED_Flashing_OVP*2;
						}	
					}
				}
			}
		}
		else{
			if(led_flashing_times>0){
				led_flashing_count+=1;
				if(led_flashing_count>=dLED_Flashing_cycle){
					led_flashing_count = 0;
					led_flashing_times-=1;
					LED_OUT=!LED_OUT;
				}
			}
			else{
				led_flashing_count+=1;
				if(led_flashing_count>=dLED_OFF_Delay_TIME){
					led_flashing_count = 0;
					led_flashing_sw = 0;
				}
					
			}
		}
	}
#endif